package ru.yandex.autotests.directapi.sandbox.banners;

import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 10.09.14
 * check for https://st.yandex-team.ru/DIRECT-33440
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
public class BannerStatusActivatingTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = Logins.CLIENT_FREE_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void checkBannerStatusActivating() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        log.info("Проверяем, что баннер промодерировался");
        api.userSteps.adsSteps().adsModerate(adId1);
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().statusChanged(adId1, StatusEnum.ACCEPTED));
        Long adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        log.info("Проверяем, что второй баннер промодерировался");
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().statusChanged(adId2, StatusEnum.ACCEPTED));
        log.info("Подождем, пока объявление станет активным");
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().stateChanged(adId2, StateEnum.ON));
    }
}
