package ru.yandex.autotests.directapi.sandbox.banners;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * Created by chicos on 01.09.14.
 * <p/>
 * Тест перенесен из старого проекта:
 * ru.yandex.autotests.directapi.tests.sandbox.statuses.CampaignStatusModerateTest
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
public class CampaignStatusModerateTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = SandboxLogins.SANDBOX_CAMPAIGN_STATUS_MODERATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(clientLogin, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    public void checkCampaignWithBannersStatusThroughModerationTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        Long adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        Long adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        log.info("Проверяем последовательно статус баннера после отправки на модерацию");
        api.userSteps.adsSteps().adsModerate(adId1);
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().statusChanged(adId1, StatusEnum.ACCEPTED));

        log.info("Оплатим кампанию");
        api.userSteps.financeSteps().payCampaignSandbox(100000f, Currency.RUB, campaignId.intValue());

        log.info("Подождем, пока объявление станет активным");
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().stateChanged(adId1, StateEnum.ON));

        AdGetItem ad2 = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.STATE, AdFieldEnum.STATUS)
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId2))).getAds().get(0);
        AdGetItemMap expectedAd2 = new AdGetItemMap().withStatus(StatusEnum.DRAFT).withState(StateEnum.OFF);
        TestSteps.assertThat("статусы баннера не отправленного на модерацию не изменились",
                ad2, beanEquals(expectedAd2.getBean()));

        log.info("Подождем активацию кампании");
        ConditionFactories.SANDBOX_STATUS.await("campaign is active")
                .until(api.userSteps.campaignSteps().campaingIsOn(campaignId));
    }

    @Test
    public void checkCampaignWithBannersStatusThroughModerationAllTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        Long adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        Long adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        log.info("Проверяем последовательно статус баннера после отправки на модерацию");
        api.userSteps.adsSteps().adsModerate(adId1, adId2);
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().statusChanged(adId1, StatusEnum.ACCEPTED));
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().statusChanged(adId2, StatusEnum.ACCEPTED));

        log.info("Оплатим кампанию");
        api.userSteps.financeSteps().payCampaignSandbox(100000f, Currency.RUB, campaignId.intValue());

        log.info("Подождем, пока объявление 1 станет активным");
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().stateChanged(adId1, StateEnum.ON));
        log.info("Подождем, пока объявление 2 станет активным");
        ConditionFactories.SANDBOX_STATUS
                .until(api.userSteps.adsSteps().stateChanged(adId2, StateEnum.ON));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(clientLogin);
    }
}
