package ru.yandex.autotests.directapi.sandbox.clients;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsString;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 26.09.14.
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
public class CreateNewSubclientTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String agency = SandboxLogins.AGENCY_SANDBOX_1;
    private static final String SUBCLIENT_BASE = "sandboxSubclient";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agency);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(agency, APISandboxClientTypeEnum.AGENCY, false);
    }

    @Test
    public void createSubclientByAgencySandboxTest() {
        CreateNewSubclientResponse client = api.userSteps.clientSteps().createNewAgencySubClient(SUBCLIENT_BASE, agency, Currency.RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("вернулся корректный логин субклиента", clientInfo.getLogin(), containsString(SUBCLIENT_BASE));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(agency);
    }


}
