package ru.yandex.autotests.directapi.sandbox.clients;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 22.06.15.
 * https://st.yandex-team.ru/TESTIRT-5998
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-42882")
@Description("Проверка наличия доступа к песочнице для приложения с полным доступом")
public class PingApiFullAccessTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_FOR_CHECK_APPS;
    private static final String APP_FULL_ACCESS_ACCEPTED = "c4c65be43049495099bd13baafddde6b";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandbox(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    public void pingApiFullAccess() {
        int result = api.as(LOGIN).applicationID(APP_FULL_ACCESS_ACCEPTED).userSteps.pingAPISteps().pingAPI();
        assertThat("метод PingAPI вернул 1", result, equalTo(1));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(LOGIN);
    }
}
