package ru.yandex.autotests.directapi.sandbox.finance;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 27.10.14
 * https://st.yandex-team.ru/TESTIRT-2839
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
public class AccountManagementClientTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = SandboxLogins.SANDBOX_INIT_CLIENT6;
    private static int accountID;
    Money minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();

    @BeforeClass
    public static void initSandbox() {
        api.as(client).userSteps.sandboxSteps()
                .enableSandboxByApi(client, APISandboxClientTypeEnum.CLIENT, true, Currency.RUB, true);
        accountID = api.userSteps.financeSteps().getAccountID(client);
    }

    @Test
    public void checkAccountManagementUpdate() {
        Account account = api.userSteps.financeSteps().getAccount(accountID);
        AccountManagementResponse response = api.userSteps.financeSteps().update(new AccountMap(account));
        assumeThat("AccountManagement.update вернул непустой результат",
                response.getActionsResult().length, greaterThan(0));
        int accountIDAfterUpdate = response.getActionsResult()[0].getAccountID();
        assertThat("метод AccountManagement.update успешно завершился", accountIDAfterUpdate, equalTo(accountID));
    }

    @Test
    public void checkAccountManagementInvoice() {
        PaymentMap payment = new PaymentMap(api.type())
                .withAccountID(accountID)
                .withCurrency(Currency.RUB)
                .withAmount(minInvoiceAmount.floatValue());
        AccountManagementResponse response = api.userSteps.financeSteps().invoiceInSandbox(payment);
        assumeThat("AccountManagement.invoice вернул непустой результат",
                response.getActionsResult().length, greaterThan(0));
        assertThat("сформирован корректный URL выставленного счета",
                response.getActionsResult()[0].getURL(), containsString("request_id"));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(client);
    }
}
