package ru.yandex.autotests.directapi.sandbox.finance;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 18.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8247
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-50054")
@Features(ApiFeatures.SANDBOX)
public class EnableCampaignWithSharedAccountTest {

    private static LogSteps log = LogSteps.getLogger(EnableCampaignWithSharedAccountTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String clientLogin = SandboxLogins.SINGLE_CLIENT_SANDBOX_16;
    private static ClientInfo clientInfo;

    @BeforeClass
    public static void initSandbox() {
        api.as(clientLogin).userSteps.sandboxSteps()
                .enableSandboxByApi(clientLogin, APISandboxClientTypeEnum.CLIENT, true, Currency.RUB, true);
        clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        assumeThat("у субклиента включен общий счет", clientInfo.getSharedAccountEnabled(), equalTo(Status.YES));
    }

    @Test
    public void enableCampaignWithSharedAccount() {
        List<CampaignGetItem> campaignIDs = api.userSteps.campaignSteps().getCampaigns(clientLogin);
        assumeThat("найдена хотя бы одна кампания", campaignIDs, hasSize(greaterThan(0)));

        Long campaignId = campaignIDs.get(0).getId();

        log.info("Подождем активации кампаний в Песочнице");
        ConditionFactories.SANDBOX_STATUS.until(
                api.userSteps.campaignSteps().stateChanged(campaignId, CampaignStateGetEnum.ON));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(clientLogin);
    }

}
