package ru.yandex.autotests.directapi.sandbox.finance;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author pavryabov
 * Date 27.10.14
 * https://st.yandex-team.ru/TESTIRT-2839
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
public class EnableSharedAccountTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String agency = SandboxLogins.SANDBOX_INIT_CLIENT5;
    private static CreateNewSubclientResponse client;

    @BeforeClass
    public static void initSandbox() {
        api.as(agency).userSteps.sandboxSteps()
                .enableSandboxByApi(agency, APISandboxClientTypeEnum.AGENCY, true, Currency.RUB, false);
        client = api.userSteps.clientSteps().createNewAgencySubClient("subclient", agency, Currency.RUB);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assumeThat("у субклиента отключен общий счет",
                clientInfo.getSharedAccountEnabled(), equalTo(Status.NO));
    }

    @Test
    public void enableSharedAccount() {
        //DIRECT-36180
        api.userSteps.campaignSteps().addDefaultTextCampaign(client.getLogin());
        api.userSteps.financeSteps().enableSharedAccount(client.getLogin());
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client.getLogin());
        assertThat("у субклиента включен общий счет",
                clientInfo.getSharedAccountEnabled(), equalTo(Status.YES));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(agency);
    }
}
