package ru.yandex.autotests.directapi.sandbox.finance;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author pavryabov
 * Date 27.10.14
 * https://st.yandex-team.ru/TESTIRT-2839
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
public class InitSandboxWithCurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String client = SandboxLogins.SANDBOX_INIT_CLIENT2;
    private static ClientInfo clientInfo;

    @BeforeClass
    public static void initSandbox() {
        api.as(client).userSteps.sandboxSteps()
                .enableSandboxByApi(client, APISandboxClientTypeEnum.CLIENT, true, Currency.RUB, false);
        clientInfo = api.userSteps.clientSteps().getClientInfo(client);
    }

    @Test
    public void checkCurrency() {
        assertThat("у клиента в песочнице есть валюта",
                clientInfo.getClientCurrencies(), equalTo(new String[]{Currency.RUB.toString()}));
    }

    @Test
    public void checkWallet() {
        assertThat("у клиента в песочнице отключен общий счет",
                clientInfo.getSharedAccountEnabled(), equalTo(Status.NO));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(client);
    }
}
