package ru.yandex.autotests.directapi.sandbox.finance;

import java.util.Arrays;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.ShortClientInfo;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;

/**
 * Created by pavryabov on 29.05.15.
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-39303")
public class PayCampaignOverdraftAgencyTest {

    private final float SUM_SPENT = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue();

    private static final String agency = SandboxLogins.AGENCY_SANDBOX_OVERDRAFT;

    private static Long campaignId1;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.as(agency).userSteps.sandboxSteps().enableSandboxByApi(agency, APISandboxClientTypeEnum.AGENCY, true, Currency.RUB, false);
        ShortClientInfo[] clients = api.userSteps.clientSteps().getSubClients(agency);
        TestSteps.assertThat("агентство имеет несколько субклиентов", clients.length, greaterThan(0));
        String subclient1 = clients[0].getLogin();

        campaignId1 = api.userSteps.addActiveCampaign(subclient1, 1);
        api.userSteps.campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId1));
    }

    @Test
    @Description("Попытка оплаты кампании агентством по овердрафту")
    public void payCampaignOverdraftAgencyTest() {
        api.as(agency).userSteps.financeSteps().shouldGetErrorOnPayCampaignsOverdraftSandbox(
                SUM_SPENT,
                Currency.RUB,
                campaignId1.intValue(),
                new AxisError(363, AxisErrorDetails.EMPTY_STRING));
    }

    @AfterClass
    public static void closeSandbox() {
        api.as(agency).userSteps.sandboxSteps().closeSandbox(agency);
    }
}
