package ru.yandex.autotests.directapi.sandbox.finance;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 20.02.15.
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-39303")
public class PayCampaignOverdraftClientTest {
    private static LogSteps log = LogSteps.getLogger(PayCampaignOverdraftClientTest.class);

    private static final String client = SandboxLogins.SINGLE_CLIENT_SANDBOX_OVERDRAFT;

    private static Long campaignId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        //подготовим клиента
        api.as(client).userSteps.sandboxSteps().enableSandboxByApi(client, APISandboxClientTypeEnum.CLIENT, false, Currency.RUB, false);
        campaignId2 = api.userSteps.addModeratedCampaign(client);
        api.userSteps.campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId2)); // нет смысла в песочнице подчищать кампании
    }

    @Test
    @Description("Оплата в рублях кампании клиентом по овердрафту")
    public void payCampaignOverdraftRubClientTest() {
        final Money sum = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();
        api.as(client);
        CampaignGetItem campaignBefore = api.userSteps.campaignSteps().getCampaigns(campaignId2).get(0);
        api.userSteps.financeSteps().payCampaignSandboxOverdraft(Currency.RUB, sum.addVAT().floatValue(), campaignId2.intValue());
        log.info("Подождем изменение баланса кампании");
        ConditionFactories.SANDBOX_STATUS.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(client, campaignBefore, sum.bidLong().longValueForSum(), true));
    }

    @AfterClass
    public static void closeSandbox() {
        api.as(client).userSteps.sandboxSteps().closeSandbox(client);
    }
}
