package ru.yandex.autotests.directapi.sandbox.finance;

import java.util.Arrays;
import java.util.Collection;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.directapi.steps.finance.FinanceSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;



/**
 * Created by chicos on 30.09.14.
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@RunWith(Parameterized.class)
public class PayCampaignsPayMethodNegativeTest {
    private static LogSteps log = LogSteps.getLogger(PayCampaignsPayMethodNegativeTest.class);
    private final float SUM_SPENT = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue();
    private PayCampaignsInfoMap payInfoMap;

    private static final String client = SandboxLogins.SINGLE_CLIENT_SANDBOX_3;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String paymentMethod;

    @Parameterized.Parameters(name = "method = {0}")
    public static Collection roles(){
        Object[][] data = new Object[][]{
                {"bank"},
                {"ym"},
                {"BANK"},
                {"Ym"},
                {""}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(client, APISandboxClientTypeEnum.CLIENT, true);

        log.info("Подождем активации кампаний в Песочнице");
        ConditionFactories.SANDBOX_STATUS.until(api.userSteps.campaignSteps().hasOnCampaign(client));

        campaignId =  api.userSteps.campaignSteps().getOnCampaigns(client).get(0).getId();
    }

    @Before
    public void prepareMap(){
        payInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(paymentMethod)
                .withContractID(FinanceSteps.SANDBOX_CONTRACT)
                .withPayments(new PayCampElementMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withCurrency(Currency.RUB)
                        .withSum(SUM_SPENT));
    }

    @Test
    public void payUsingFinanceTokenTest() {
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaignsSandbox(
                new AxisError(71, AxisErrorDetails.FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT),
                payInfoMap
        );
    }

    @Test
    public void payUsingPaymentTokenTest() {
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaignsYMSandbox(
                new AxisError(71, AxisErrorDetails.FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT),
                payInfoMap
        );
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(client);
    }
}
