package ru.yandex.autotests.directapi.sandbox.images;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.AdImageResponse;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 10.06.15.
 * https://st.yandex-team.ru/TESTIRT-5865
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-41039")
@Description("Проверка загрузки картинки в песочнице")
public class AdImageUploadTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_13;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    public void adImageUploadRequest() {
        AdImageResponse response = api.userSteps.imagesSteps().adImageUpload(new AdImageURLMap(api.type())
                .withName(RandomStringUtils.randomAlphabetic(10))
                .withURL(ImagesSteps.getDefaultImageUrl(4, ImageType.REGULAR))
                .withLogin(LOGIN));

        assumeThat("картинка добавилась в очередь на загрузку", response.getActionsResult(),
                arrayWithSize(greaterThanOrEqualTo(1)));
        int taskID = response.getActionsResult()[0].getAdImageUploadTaskID();

        api.userSteps.imagesSteps().waitForImageHandleResult(taskID);
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandbox(LOGIN);
    }
}
