package ru.yandex.autotests.directapi.sandbox.stat;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.GetForecastInfo;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.emptyArray;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 24.04.14.
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-41399")
@Description("Построение forecast в Песочнице. Доступно только на ТС")
public class CreateNewForecastTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientLogin = SandboxLogins.SINGLE_CLIENT_SANDBOX_5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовка данных для теста")
    public void initSandbox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(clientLogin, APISandboxClientTypeEnum.CLIENT, false);
        log.info("Удалим все forecast отчеты");
        api.userSteps.forecastSteps().deleteForecastReports();
    }

    @Test
    public void createForecastTest() {
        log.info("Создание отчета Forecast с одной фразой");
        int forecastID = api.userSteps.forecastSteps().createNewForecast(new NewForecastInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("новогодние подарки")
                .withCategories(new int[0]));
        log.info("Запрос сформированного forecast id = " + forecastID);
        GetForecastInfo forecastInfo = api.userSteps.forecastSteps().getForecast(forecastID);

        assertThat("forecast содержит данные по фразе", forecastInfo.getPhrases(), arrayWithSize(1));
        assertThat("отсутствуют данные по категориям", forecastInfo.getCategories(), emptyArray());
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.forecastSteps().bin.clearBin();
        api.userSteps.sandboxSteps().closeSandbox(clientLogin);
    }
}
