package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-5383
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-38497")
@Description("Проверка работоспособности сервиса AdGroups в песочнице")
public class AdGroupsTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignID;

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Test
    @Description("Создание группы объявлений в песочнице")
    public void addAdGroupInSandbox() {
        api.userSteps.adGroupsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAdGroups(new AdGroupAddItemMap()
                                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                                .withRegionIds(0l)
                                .withCampaignId((long) campaignID)),
                ExpectedResult.success());
    }

    @Test
    @Description("Удалить группу объявлений в песочнице")
    public void deleteAdGroupInSandbox() {
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        api.userSteps.adGroupsSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(adGroupID)),
                ExpectedResult.success(adGroupID));
    }

    @Test
    @Description("Получить группу объявлений в песочнице")
    public void getAdGroupInSandBox() {
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withFieldNames(AdGroupFieldEnum.ID)
                .withSelectionCriteria(new AdGroupsSelectionCriteriaMap()
                        .withIds(adGroupID)));
        assertThat("получена одна группа", response.getAdGroups(), beanEquivalent(Arrays.asList(
                (AdGroupGetItem) new AdGroupGetItemMap()
                        .withId(adGroupID).getBean())));
    }

    @Test
    @Description("Обновить группу объявлений в песочнице")
    public void updateAdGroupInSandBox() {
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(new AdGroupUpdateItemMap()
                                .withId(adGroupID)
                                .withName("New Ad Group name")),
                ExpectedResult.success(adGroupID));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
