package ru.yandex.autotests.directapi.sandbox.v5;

import com.yandex.direct.api.v5.agencyclients.AddResponse;
import com.yandex.direct.api.v5.agencyclients.AgencyClientFieldEnum;
import com.yandex.direct.api.v5.agencyclients.AgencyClientsSelectionCriteria;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.agencyclients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-67952")
@Description("Проверка работоспособности сервиса AgencyClients в песочнице")
public class AgencyClientsTest {
    private static final String LOGIN = SandboxLogins.SANDBOX_AGENCYCLIENTS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.AGENCY, true);
    }

    @Test
    public void getSmokeTest() {
        GetResponse response = api.userSteps.agencyClientsStepsV5().agencyClientsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AgencyClientsSelectionCriteria())
                        .withFieldNames(AgencyClientFieldEnum.CLIENT_ID, AgencyClientFieldEnum.CLIENT_INFO));
        assertThat("список клиентов не пустой", response.getClients().size(), greaterThan(0));
    }

    @Test
    public void addSomeTest() {
        final String newClientLogin = AddRequestMap.generateLogin("testcl");
        final AddResponse createdClient = api.userSteps.agencyClientsStepsV5().agencyClientsAdd(
                new AddRequestMap()
                        .withDefault(newClientLogin)
        );
        assertThat("создали клиента", createdClient.getLogin(), Matchers.is(newClientLogin));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
