package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.audiencetargets.DeleteResponse;
import com.yandex.direct.api.v5.audiencetargets.ResumeResponse;
import com.yandex.direct.api.v5.audiencetargets.SetBidsResponse;
import com.yandex.direct.api.v5.audiencetargets.SuspendResponse;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingConditionResponse;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionGoalItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-67952")
@Description("Проверка работоспособности сервиса AudienceTargets в песочнице")
public class AudienceTargetsTest {
    private static final String LOGIN = SandboxLogins.SANDBOX_AUDIENCETARGETS_CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, true);
    }

    @Test
    public void smokeTest() {
        RetargetingConditionResponse conditionResponse = api.userSteps.retargetingSteps().retargetingConditionAdd(
                new RetargetingConditionMap(api.type())
                        .defaultRetargeting(LOGIN)
                        .withRetargetingConditionItems(
                                new RetargetingConditionItemMap(api.type())
                                        .withType(RetargetingType.ALL)
                                        .withGoals(new RetargetingConditionGoalItemMap(api.type())
                                                .withTime(1)
                                                .withGoalID(1L))));
        assumeThat("getRetargetingConditionID not null", conditionResponse.getActionsResult()[0].getRetargetingConditionID(), notNullValue());

        Long retargetingId = conditionResponse.getActionsResult()[0].getRetargetingConditionID().longValue();

        // add
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, LOGIN);
        List<Long> ids = api.userSteps.audienceTargetsSteps().add(new AddRequestMap().withAudienceTargets(
                new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withContextBid(1000000L)
                        .withStrategyPriority(PriorityEnum.HIGH)
                        .withRetargetingListId(retargetingId)));
        assertThat("audience target успешно добавлен",
                ids.size(), greaterThan(0));
        Long id = ids.get(0);

        // get
        List<AudienceTargetGetItem> result = api.userSteps.audienceTargetsSteps().get(new GetRequestMap()
                .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap().withRetargetingListsIds(retargetingId))
                .withFieldNames(AudienceTargetFieldEnum.ID));
        assertThat("вернулся добавленный audience target", result.size(), greaterThan(0));

        // suspend
        SuspendResponse suspendResponse = api.userSteps.audienceTargetsSteps().suspend(id, LOGIN);
        assertThat("suspend прошел успешно", suspendResponse.getSuspendResults().get(0).getId(), equalTo(id));

        // resume
        ResumeResponse resumeResponse = api.userSteps.audienceTargetsSteps().resume(id, LOGIN);
        assertThat("resume прошел успешно", resumeResponse.getResumeResults().get(0).getId(), equalTo(id));

        // set bids
        SetBidsResponse setBidsResponse = api.userSteps.audienceTargetsSteps().setBids(new SetBidsRequestMap().withBids(
                new AudienceTargetSetBidsItemMap().withId(id).withContextBid(2000000L)));
        assertThat("setBids прошел успешно", setBidsResponse.getSetBidsResults().get(0).getId(), equalTo(id));

        // delete
        DeleteResponse deleteResponse = api.userSteps.audienceTargetsSteps().delete(LOGIN, id);
        assertThat("delete прошел успешно", deleteResponse.getDeleteResults().get(0).getId(), equalTo(id));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
