package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-5383
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-38497")
@Description("Проверка работоспособности сервиса Bids в песочнице")
public class BidsTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_8;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private static long keywordId;

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, LOGIN);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

    }

    @Test
    @Description("Установка ставки в песочнице")
    public void setBidInSandBox() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(
                new SetRequestMap()
                        .withBids(
                                new BidSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withBid(1100000L)),
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @Description("Атоматическая установка ставки в песочнице")
    public void setAutoBidInSandBox() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(new SetAutoRequestMap()
                .withBids(new BidSetAutoItemMap()
                        .withKeywordId(keywordId)
                        .withPosition(PositionEnum.FOOTERBLOCK)
                        .withContextCoverage(10)
                        .withCalculateBy(CalculateByEnum.DIFF)
                        .withScope(ScopeEnum.SEARCH)),
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @Description("Получение ставки в песочнице")
    public void getBidInSandBox() {
        GetResponse response = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.KEYWORD_ID)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withKeywordIds(keywordId)));
        assertThat("ставка для ключевого слова вернулась", response.getBids(), beanEquivalent(Arrays.asList(
                (BidGetItem) new BidsGetItemMap()
                        .withKeywordId(keywordId).getBean())));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
