package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import com.yandex.direct.api.v5.changes.CheckDictionariesResponse;
import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 05.05.15.
 * https://st.yandex-team.ru/TESTIRT-5383
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-38497")
@Description("Проверка работоспособности сервиса Changes в песочнице")
public class ChangesTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_9;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    @Description("Проверка метода Changes.Check в песочнице")
    public void checkInSandbox() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds((long) campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds(), hasSize(0));
    }

    @Test
    @Description("Проверка метода Changes.CheckCampaigns в песочнице")
    public void checkCampaignsInSandbox() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckCampaignsRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse,beanEquivalent(expectedCampaignResponse)
                .withVariation(variation));
    }

    @Test
    @Description("Проверка метода Changes.CheckDictionaries в песочнице")
    public void checkDictionariesInSandbox() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        CheckDictionariesResponse actualCheckDictionariesResponse =
                api.userSteps.changesSteps().changesCheckDictionaries(
                        new CheckDictionariesRequestMap()
                                .withTimestamp(timestamp)
                );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckDictionariesRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckDictionariesResponse expectedCheckDictionariesResponse = new CheckDictionariesResponse();
        expectedCheckDictionariesResponse.setRegionsChanged(YesNoEnum.NO);
        expectedCheckDictionariesResponse.setTimeZonesChanged(YesNoEnum.NO);
        assertThat("вернулись корректные поля", actualCheckDictionariesResponse,
                beanEquivalent(expectedCheckDictionariesResponse).withVariation(variation));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
