package ru.yandex.autotests.directapi.sandbox.v5;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeRequest;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeResponse;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeSelectionCriteria;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.keywordsresearch.HasSearchVolumeRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-67952")
@Description("Проверка работоспособности сервиса KeywordsResearch в песочнице")
public class KeywordsResearchTest {
    private static final String LOGIN = SandboxLogins.SANDBOX_KEYWORDSRESEARCH_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    @Description("Получить количество показов в песочнице")
    public void hasSearchVolumesInSandbox() {
        HasSearchVolumeRequest request = new HasSearchVolumeRequest();
        request.setFieldNames(asList(HasSearchVolumeFieldEnum.KEYWORD,
                HasSearchVolumeFieldEnum.ALL_DEVICES));

        HasSearchVolumeSelectionCriteria selectionCriteria = new HasSearchVolumeSelectionCriteria();
        selectionCriteria.setKeywords(singletonList("носки"));
        selectionCriteria.setRegionIds(singletonList(0L));
        request.setSelectionCriteria(selectionCriteria);
        HasSearchVolumeResponse response = api.userSteps.keywordsResearchSteps().keywordsResearchHasSearchVolumeRawResponse(
                        LOGIN,
                        new HasSearchVolumeRequestMap(request));
        assertThat("ответ из сервиса получен", response.getHasSearchVolumeResults(),
                hasSize(1));
    }


    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
