package ru.yandex.autotests.directapi.sandbox.v5;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.reports.DateRangeTypeEnum;
import com.yandex.direct.api.v5.reports.FieldEnum;
import com.yandex.direct.api.v5.reports.FormatEnum;
import com.yandex.direct.api.v5.reports.ReportTypeEnum;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.reports.ReportDefinitionMap;
import ru.yandex.autotests.directapi.model.api5.reports.ReportsData;
import ru.yandex.autotests.directapi.model.api5.reports.SelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 20.05.2019
 * https://st.yandex-team.ru/DIRECT-95000
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-95000")
@Description("Проверка работоспособности сервиса Reports в песочнице")
public class ReportsTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String DATE_FROM = LocalDate.now()
            .minusYears(2)
            .minusMonths(1)
            .toString(DateTimeFormat.forPattern("yyyy-MM-dd"));
    private static final String DATE_TO = LocalDate.now()
            .minusYears(2)
            .toString(DateTimeFormat.forPattern("yyyy-MM-dd"));

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    @Description("Получение статистики в песочнице")
    public void testGetReport() {
        ReportDefinitionMap reportDefinitionMap = new ReportDefinitionMap()
                .withSelectionCriteria(new SelectionCriteriaMap()
                        .withDateTo(DATE_TO)
                        .withDateFrom(DATE_FROM))
                .withFieldNames(FieldEnum.AVG_TRAFFIC_VOLUME, FieldEnum.WEIGHTED_CTR, FieldEnum.CONVERSIONS)
                .withUniqueReportName()
                .withReportType(ReportTypeEnum.CUSTOM_REPORT)
                .withDateRangeType(DateRangeTypeEnum.CUSTOM_DATE)
                .withFormat(FormatEnum.TSV)
                .withIncludeVAT(YesNoEnum.NO);

        ReportsData reportsData = api.userSteps.reportsSteps().callReportsXml(reportDefinitionMap);
        assertThat("отчет получен успешно", reportsData.getReportsLines(), notNullValue());

    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
