package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListFieldEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListGetItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-67952")
@Description("Проверка работоспособности сервиса RetargetingLists в песочнице")
public class RetargetingListsTest {
    // ждет тикета https://st.yandex-team.ru/DIRECT-61406
    private static final String LOGIN = SandboxLogins.SANDBOX_RETARGETINGLISTS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, true);
    }

    @Test
    public void smokeTest() {
        // create
        String NAME = RandomUtils.getString(10);
        String DESCRIPTION = RandomUtils.getString(10);
        Long correctGoalId = api.userSteps.retargetingSteps().getRetargetingGoalIDs(LOGIN).get(0);

        List<Long> idList = api.userSteps.retargetingListsSteps().add(new AddRequestMap()
                .withRetargetingLists(
                        new RetargetingListAddItemMap()
                                .withDescription(DESCRIPTION)
                                .withName(NAME)
                                .withRules(new RetargetingListRuleItemMap()
                                        .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                        .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                .withDefaultMembershipLifeSpan()
                                                .withExternalId(correctGoalId)))));
        assertThat("добавился один объект", idList, iterableWithSize(1));
        Long retargetingListsId = idList.get(0);

        // retrieve
        List<RetargetingListGetItem> listsGetItems = api.userSteps.retargetingListsSteps().get(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.GetRequestMap()
                        .withFieldNames(RetargetingListFieldEnum.ID)
                        .withSelectionCriteria(new RetargetingListSelectionCriteriaMap()
                                .withIds(retargetingListsId)));
        RetargetingListGetItem expected = (RetargetingListGetItem) new RetargetingListGetItemMap().withId(retargetingListsId).getBean();
        assertThat("Get вернул ожидаемый объект", listsGetItems, beanDifferV5(singletonList(expected)));

        // update
        api.userSteps.retargetingListsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withRetargetingLists(
                                new RetargetingListUpdateItemMap()
                                        .withId(retargetingListsId)
                                        .withRules(new RetargetingListRuleItemMap()
                                                .withOperator(RetargetingListRuleOperatorEnum.ALL)
                                                .withArgumentItems(new RetargetingListRuleArgumentItemMap()
                                                        .withRandomMembershipLifeSpan()
                                                        .withExternalId(correctGoalId)))),
                ExpectedResult.success());

        // delete
        api.userSteps.retargetingListsSteps()
                .shouldGetResultOnDelete(
                        new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(retargetingListsId)), ExpectedResult.success());
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }

}
