package ru.yandex.autotests.directapi.sandbox.v5;

import com.yandex.direct.api.v5.sitelinks.SitelinksSetFieldEnum;
import com.yandex.direct.api.v5.sitelinks.SitelinksSetGetItem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.*;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 05.05.15.
 * https://st.yandex-team.ru/TESTIRT-5383
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-38497")
@Description("Проверка работоспособности сервиса Sitelinks в песочнице")
public class SitelinksTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_11;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();


    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
    }

    @Test
    @Description("Добавить набор сайтлинков в песочнице")
    public void addSitelinksSetInSandbox() {
        api.userSteps.sitelinksSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .defaultSitelinksSet(1)),
                ExpectedResult.success());
    }

    @Test
    @Description("Удалить набор сайтлинков в песочнице")
    public void deleteSitelinksSetInSandbox() {
        long sitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);

        api.userSteps.sitelinksSteps().shouldGetResultOnDelete(new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(sitelinksSetID)),
                ExpectedResult.success(sitelinksSetID));
    }

    @Test
    @Description("Получить набор сайтлинков в песочнице")
    public void getSitelinksSetInSandbox() {
        long sitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);

        List<SitelinksSetGetItem> sitelinks = api.userSteps.sitelinksSteps().get(new GetRequestMap()
                .withFieldNames(SitelinksSetFieldEnum.ID)
                .withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(sitelinksSetID)));
        assertThat("набор сайтлинков был успешно получен", sitelinks, beanEquivalent(Arrays.asList(
                (SitelinksSetGetItem) new SitelinksSetGetItemMap()
                        .withId(sitelinksSetID).getBean())));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
