package ru.yandex.autotests.directapi.sandbox.v5;

import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.sandbox.SandboxLogins;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-5383
 */
@Aqua.Test
@Features(ApiFeatures.SANDBOX)
@Issue("https://st.yandex-team.ru/DIRECT-38497")
@Description("Проверка работоспособности сервиса VCards в песочнице")
public class VCardsTest {

    private static final String LOGIN = SandboxLogins.SINGLE_CLIENT_SANDBOX_12;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignID;

    @BeforeClass
    public static void initSandBox() {
        api.userSteps.sandboxSteps().enableSandboxByApi(LOGIN, APISandboxClientTypeEnum.CLIENT, false);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Test
    @Description("Добавить визитную карточку в песочнице")
    public void addVCardInSandBox() {
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .defaultContacts()
                                .withCampaignId(campaignID)),
                ExpectedResult.success());
    }

    @Test
    @Description("Удалить визитную карточку в песочнице")
    public void deleteVCardInSandBox() {
        List<Long> vCardIDs = api.userSteps.vCardsSteps().vCardsAdd(new VCardAddMap()
                        .defaultContacts()
                        .withCampaignId(campaignID));
        assumeThat("была создана одна визитная карточка", vCardIDs, hasSize(1));
        long vCardID = vCardIDs.get(0);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(vCardID)),
                ExpectedResult.success(vCardID));
    }

    @Test
    @Description("Получить визитную карточку в песочнице")
    public void getCardInSandBox() {
        List<Long> vCardIDs = api.userSteps.vCardsSteps().vCardsAdd(new VCardAddMap()
                .defaultContacts()
                .withCampaignId(campaignID));
        assumeThat("была создана одна визитная карточка", vCardIDs, hasSize(1));
        long vCardID = vCardIDs.get(0);

        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(vCardID);
        assertThat("вернулась одна визитная карточка", vCards, hasSize(1));
    }

    @AfterClass
    public static void closeSandbox() {
        api.userSteps.sandboxSteps().closeSandboxByApi(LOGIN);
    }
}
