package ru.yandex.autotests.directapi.stat.createforecast;

import ch.lambdaj.function.convert.PropertyExtractor;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ForecastStatusInfo;
import ru.yandex.autotests.directapi.common.api45.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Collections;
import java.util.List;

import static ch.lambdaj.Lambda.convert;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasItems;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 29.12.13
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-412
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
@Stories(ApiStories.CURRENCY)
public class CreateNewForecastQueueWithCurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(
            Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_FORECAST_CURRENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Integer[] reportsId;

    @BeforeClass
    public static void createReportQueue() {
        api.userSteps.forecastSteps().deleteForecastReports();
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type());
        newForecastInfoMap.withGeoID(1);
        String[] currencies = new String[]{
                Currency.USD.toString(),
                Currency.CHF.toString(),
                Currency.KZT.toString(),
                Currency.BYN.toString()
        };
        reportsId = new Integer[0];

        for (String currency : currencies) {
            newForecastInfoMap.withPhrases("майские праздники");
            newForecastInfoMap.withCurrency(currency);
            int reportId = api.userSteps.forecastSteps().createNewForecast(newForecastInfoMap);
            ArrayUtils.add(reportsId,reportId);
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7037")
    public void createForecastWithCurrencyQueue() {
        ForecastStatusInfo[] reports = api.userSteps.forecastSteps().getForecastList();
        List<Integer> gotReportIds = convert(reports, new PropertyExtractor("forecastID"));
        Collections.sort(gotReportIds);
        assertThat(gotReportIds, hasItems(reportsId));

        for (int id : reportsId) {
            GetForecastInfo forecast = api.userSteps.forecastSteps().getForecast(id);
            assertThat("Не получен прогноз по фразам", forecast.getPhrases().length, greaterThan(0));
        }
    }
}
