package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.GetForecastInfo;
import ru.yandex.autotests.directapi.common.api45.PhraseAuctionBids;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.phrases.PhraseAuctionBidMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 20.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@RunWith(Parameterized.class)
@Description("Проверка проверка корректности возвращаемой структуры AuctionBids.")
public class ForecastAuctionBidsStructureTest {
    public static String forecastPhrase = "лето";

    @ClassRule
    public static ApiSteps api =
            new ApiSteps().as(Logins.SUPER_LOGIN, StatLogins.CLIENT_SELF).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocol;
    private GetForecastInfo forecastInfo;

    @Parameterized.Parameters(name = "Protocol = {0}")
    public static Collection protocol() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }


    @Before
    public void createForecastReport(){
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.value())
                .withAuctionBids(Value.YES);
        forecastInfo = api.protocol(protocol).userSteps.forecastSteps().getForecast(newForecastInfoMap);
        assumeThat("вернулcя прогноз по 1 фразе", forecastInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid",forecastInfo.getPhrases()[0].getAuctionBids(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7047")
    public void checkAuctionBidsStructureInResponse(){
        PhraseAuctionBids[] gotAuctionBids = forecastInfo.getPhrases()[0].getAuctionBids();
        AuctionBidsPositionForBids[] positions = AuctionBidsPositionForBids.values();
        List<PhraseAuctionBids> expectedAuctionBids =  Stream.of(positions)
                .map(position ->
                        (PhraseAuctionBids)
                                new PhraseAuctionBidMap(api.type())
                                        .withPosition(position.toString())
                                        .withBid(0f)
                                        .withPrice(0f).getBean()

                )
                .collect(Collectors.toList());
        MatchVariation variation = new DefaultMatchVariation().forClasses(Float.class).useMatcher(greaterThan(0f));
        assertThat("AuctionBids возвращается корректной стрыктуры", Arrays.asList(gotAuctionBids),
                beanDiffer(expectedAuctionBids).withVariation(variation));

    }

}
