package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.directapi.steps.forecast.ApproximateNumbersMatchVariation;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

/**
 * Created by ginger on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Сравнение ответа метода с и без AuctionBids.")
public class ForecastCompareWithAndWithoutAuctionBidsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api =
            new ApiSteps().as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_FORECAST_COMMON).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private int forecastID;
    private static GetForecastInfo forecastInfo;
    public static String forecastPhrase = "лето";
    private GetForecastInfo forecastInfoWithoutBids;

    @BeforeClass
    public static void createForecastReport(){
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type())
                .withPhrases(forecastPhrase)
                .withAuctionBids(Value.YES)
                .withCurrency(Currency.RUB.toString());
        forecastInfo = api.userSteps.forecastSteps().getForecast(newForecastInfoMap);
        assumeThat("вернулась структура AuctionBid",forecastInfo.getPhrases()[0].getAuctionBids(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7061")
    public void compareWithDiffValueOfAuctionBid(){
        NewForecastInfoMap newForecastInfoMapWithoutAuctionBids = new NewForecastInfoMap(api.type())
                .withPhrases(forecastPhrase)
                .withAuctionBids(Value.NO)
                .withCurrency(Currency.RUB.toString());
        forecastInfoWithoutBids = api.userSteps.forecastSteps().getForecast(newForecastInfoMapWithoutAuctionBids);
        assertThat("прогнозы совпадают",
                forecastInfo,
                beanEquivalent(forecastInfoWithoutBids)
                        .withVariation(new ApproximateNumbersMatchVariation(5, 0, true))
                        .fields(ignore(NewForecastInfoMap.AUCTION_BIDS)));
    }
}
