package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;



/**
 * User: mariabye
 * Date: 06.08.12
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-20
 */
@Aqua.Test
@Features(StatFeatures.NOT_REGRESSION_YET)
//https://st.yandex-team.ru/TESTIRT-8655
public class ForecastQueueLimitTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104)
            .as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_FORECAST_LIMIT_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7063")
    public void expectErrorWhenCreatingSixthReport() {
        api.userSteps.forecastSteps().deleteForecastReports();
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("новогодние подарки")
                .withCategories()
                .withCurrency(Currency.RUB.value());
        log.info("Вызываем метод CreateNewForecast с одной фразой");
        log.info("Вызываем метод CreateNewForecast 5 раз");

        for (int i = 0; i < 5; i++) {
            log.info(i);
            api.userSteps.forecastSteps().createNewForecast(newForecastInfoMap);
        }
        log.info("Теперь на сервере у пользователя хранится 5 отчетов. Попытаемся создать шестой");
        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.CREATE_NEW_FORECAST,
                newForecastInfoMap,
                new AxisError(31, AxisErrorDetails.REPORT_LIMIT_REACHED));
    }
}

