package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;



/**
 * User: pavryabov
 * Date: 30.12.13
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
@Stories(ApiStories.CURRENCY)
public class ForecastWithYndFixedTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_FORECAST_LOGIN);
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(
            Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_FORECAST_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7075")
    public void getReportWithYndFixedTest() {
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type());
        newForecastInfoMap.withPhrases("новогодние подарки");
        newForecastInfoMap.withCategories(new int[0]);
        newForecastInfoMap.withCurrency(Currency.YND_FIXED.value());
        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.CREATE_NEW_FORECAST,
                newForecastInfoMap,
                new AxisError(245, null));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7075")
    public void getReportWithNoCurrencyTest() {
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type());
        newForecastInfoMap.withPhrases("новогодние подарки");
        newForecastInfoMap.withCategories(new int[0]);
        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.CREATE_NEW_FORECAST,
                newForecastInfoMap,
                new AxisError(245, null));
    }
}
