package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

import static org.apache.commons.lang.StringUtils.capitalize;


/**
 * Created by ginger on 16.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Валидация поля InvalidAuctionBid.")
@RunWith(Parameterized.class)
public class InvalidJsonForecastStructureTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN, StatLogins.AUCTION_BIDS_CLIENT).version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Object invalidAuctionBid;

    public static String phraseForReport = "лето";
    public static String invalidStringAuctionBid = "maybe";
    public static Integer invalidIntegerAuctionBid = 1331;
    public static String[] invalidStructureAuctionBid = new String[]{Value.YES};

    @Parameterized.Parameters(name = "invalidAuctionBid = {0}")
    public static Collection auctionBid() {
        Object[][] data = new Object[][]{
                {invalidStringAuctionBid},
                {invalidIntegerAuctionBid},
                {invalidStructureAuctionBid}
        };
        return Arrays.asList(data);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7081")
    public void trySetInvalidAuctionBid(){
        HashMap newForecastInfoMap = new HashMap();
        newForecastInfoMap.put(capitalize(NewForecastInfoMap.PHRASES), new String[]{phraseForReport});
        newForecastInfoMap.put(capitalize(NewForecastInfoMap.AUCTION_BIDS), invalidAuctionBid);
        newForecastInfoMap.put(capitalize(NewForecastInfoMap.CURRENCY), Currency.RUB.value());
        api.userSteps.shouldGetErrorOn(
                Method.CREATE_NEW_FORECAST,
                newForecastInfoMap,
                new AxisError(25, AxisErrorDetails.FIELD,capitalize(NewForecastInfoMap.AUCTION_BIDS)));
    }
}
