package ru.yandex.autotests.directapi.stat.createforecast;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api4.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api4.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;


import java.util.Arrays;

import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.hasItem;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

@Aqua.Test
@Features(StatFeatures.CREATE_NEW_FORECAST)
public class MethodAvailabilityTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(4).as(Logins.SUPER_LOGIN, Logins.AGENCY_ANOTHER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void methodCreateNewForecastNotAvailableTest() {
        api.userSteps.forecastSteps().shouldGetErrorOn(Method.CREATE_NEW_FORECAST,
                new NewForecastInfoMap(api.version(4).type()), new AxisError(509));
    }

    @Test
    public void methodGetForecastNotAvailableTest() {
        api.userSteps.forecastSteps().shouldGetErrorOn(Method.GET_FORECAST,
                new GetForecastInfo(), new AxisError(509));
    }
}
