package ru.yandex.autotests.directapi.stat.createnewwordstatreport;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.PhraseTexts;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.directapi.steps.forecast.ForecastSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by ginger on 23.03.16.
 * https://jira.yandex-team.ru/browse/TESTIRT-70
 */
@Aqua.Test
@Features(StatFeatures.BUG)
@RunWith(Parameterized.class)
public class CreateNewWordstatReportFailedTest {  private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_WORDSTAT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_WORDSTAT);
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-50693")
    @ru.yandex.qatools.allure.annotations.TestCaseId("7173")
    public void expectErrorWhenCreatingSixthReport() {
        api.userSteps.forecastSteps().deleteWordstatReports();
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("новогодние подарки");

        for (int i = 0; i < ForecastSteps.WORDSTAT_REPORT_QUEUE_LIMIT; i++) {
            api.userSteps.forecastSteps().createNewWordstat(reportInfo);
        }

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.CREATE_NEW_WORDSTAT_REPORT,
                reportInfo,
                new AxisError(31, AxisErrorDetails.REPORT_LIMIT_REACHED));
    }

}
