package ru.yandex.autotests.directapi.stat.createnewwordstatreport;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 30.11.12
 *
 * https://jira.yandex-team.ru/browse/TESTIRT-70
 */
@Aqua.Test
@Features(StatFeatures.CREATE_NEW_WORDSTAT)
@RunWith(Parameterized.class)
public class CreateNewWordstatReportRelevanceTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps()
            .as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_WORDSTAT_RELEVANCE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameters
    public static Collection reportRequests() {
        List<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{4});
        params.add(new Object[]{104});
        return params;
    }

    @Parameterized.Parameter
    public int version;

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_WORDSTAT_RELEVANCE);
    }

    @Before
    public void setVersion() {
        api.version(version);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7159")
    public void couldCreateNewWordstatReportWithSimplePhrase() {
        String requestPhrase = "ремонт квартир";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases(requestPhrase);
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportSearchedWithPhrases(reportInfo);

        assertThat("несоответствие для фразы \"" + requestPhrase + "\"",
                gotPhrases.get(0), equalTo(requestPhrase));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7160")
    public void couldCreateNewWordstatReportWithMinusInPhrase() {
        String requestPhrase = "ремонт -квартир";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases(requestPhrase);
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportSearchedWithPhrases(reportInfo);

        assertThat("несоответствие для фразы \"" + requestPhrase + "\"",
                gotPhrases, hasItem("ремонт"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7161")
    public void couldCreateNewWordstatReportWithExclamationMarkInPhrase() {
        String requestPhrase = "!шариков";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withPhrases(requestPhrase);
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportSearchedWithPhrases(reportInfo);

        assertThat("несоответствие для фразы \"" + requestPhrase + "\"",
                gotPhrases, hasItems(requestPhrase, "шариков"));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7162")
    public void couldCreateNewWordstatReportWithWrongCaseInPhrase() {
        String requestPhrase = "корпоративных подарков";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases(requestPhrase);
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportSearchedWithPhrases(reportInfo);

        assertThat("несоответствие для фразы \"" + requestPhrase + "\"",
                gotPhrases, hasItems(requestPhrase, "корпоративные подарки"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7163")
    public void ccouldCreateNewWordstatReportWithDoubleWordInPhrase() {
        String requestPhrase = "ремонт ремонт";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases(requestPhrase);
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportSearchedWithPhrases(reportInfo);

        assertThat("несоответствие для фразы \"" + requestPhrase + "\"",
                gotPhrases, hasItems(requestPhrase, "ремонт"));
    }
}
