package ru.yandex.autotests.directapi.stat.createnewwordstatreport;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

/**
 * Created by chicos on 14.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1394
 */

@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Stories(ApiStories.SHARDING)
public class CreateNewWordstatReportShardingLimitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String login = StatLogins.CREATE_NEW_WORDSTAT_SHARDED_2;

    @BeforeClass
    public static void reshardUser(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(StatLogins.CREATE_NEW_WORDSTAT_SHARDED_2, ShardNumbers.EXTRA_SHARD);
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7164")
    public void expectErrorWhenMethodCallsLimitReached(){
        //выставить клиенту лимит вызовов метода CreateNewWordstatReport равный 4

        api.userSteps.clientFakeSteps().reshardUserWithLock(login, ShardNumbers.DEFAULT_SHARD);
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("концессия");
        for (int i = 0; i < 2; i++) {
            api.userSteps.forecastSteps().getWordstatReportPhrases(reportInfo);
        }
        api.userSteps.clientFakeSteps().reshardUserWithLock(login, ShardNumbers.EXTRA_SHARD);
        for (int i = 0; i < 2; i++) {
            api.userSteps.forecastSteps().getWordstatReportPhrases(reportInfo);
        }

        int callLimit = 4;
        int calledAlready = 4;
        int attemptNum = 1;
        api.userSteps.shouldGetErrorOn(Method.CREATE_NEW_WORDSTAT_REPORT, reportInfo,
                new AxisError(56, AxisErrorDetails.REQUEST_LIMIT_EXCEEDED, login, callLimit, calledAlready, attemptNum));

        //вернуть лимит вызовов в исходное зничение
    }
}
