package ru.yandex.autotests.directapi.stat.createnewwordstatreport;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.forecast.ForecastSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;

/**
 * Created by chicos on 14.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1394
 */

@Aqua.Test
@Features(StatFeatures.CREATE_NEW_WORDSTAT)
@Stories(ApiStories.SHARDING)
public class CreateNewWordstatReportUnitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String login = StatLogins.CREATE_NEW_WORDSTAT_SHARDED;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7174")
    public void checkWordstatReportUnitsCost() {
        ClientsUnitInfo unitsBefore = api.userSteps.clientSteps().getClientUnits(login);
        assertThat("Не удалось получить количество доступных баллов", unitsBefore, notNullValue());

        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("английский язык");
        api.userSteps.forecastSteps().getWordstatReportPhrases(reportInfo);
        ClientsUnitInfo unitsAfter = api.userSteps.clientSteps().getClientUnits(login);
        assertThat("Не удалось получить количество доступных баллов", unitsAfter, notNullValue());

        assertThat("Неверное количество оставшихся баллов", unitsAfter.getUnitsRest(),
                equalTo(unitsBefore.getUnitsRest() - ForecastSteps.WORDSTAT_REPORT_CREATION_COST));
    }
}
