package ru.yandex.autotests.directapi.stat.createnewwordstatreport;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.qatools.allure.annotations.Features;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.hasItem;
import static org.junit.Assert.assertThat;

/**
 * Created by chicos on 14.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1394
 */

@Aqua.Test
@Features(StatFeatures.CREATE_NEW_WORDSTAT)
@RunWith(Parameterized.class)
public class InternalRoleAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPER_READER},
                {Logins.SUPPORT},
                {Logins.PLACER},
                {Logins.MEDIA}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7175")
    public void couldCreateNewWordstatReport(){
        final String concretePhrase = "коллайдер";
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases(concretePhrase);

        List<String> phrases = api.as(Logins.SUPER_LOGIN, login)
                .userSteps.forecastSteps().getWordstatReportPhrases(reportInfo);

        assertThat("Неверный отчет", phrases, hasItem(concretePhrase));
    }
}
