package ru.yandex.autotests.directapi.stat.getforecastsync;

import com.google.common.collect.Ordering;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.common.api45mng.PhraseAuctionBids;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static java.util.Collections.reverseOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 13.08.15.
 * https://st.yandex-team.ru/TESTIRT-6714
 */
@Aqua.Test
@Features(StatFeatures.BUG)
@Stories(ApiStories.VCG)
@Issue("https://st.yandex-team.ru/DIRECT-44294")
@Description("Проверка убывания ставок и цен в AuctionBids")
public class AuctionBidsSortTest {
    private static PhraseAuctionBids[] forecastAuctionBidses;
    private LogSteps log = LogSteps.getLogger(this.getClass());
    public static String forecastPhrase = "лето";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void getForecastReports() {
        NewForecastInfoExtendedMap newForecastInfoExtendedMap = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.toString())
                .withAuctionBids(Value.YES);
        GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfoExtendedMap);
        assumeThat("вернуля прогноз по 1 фразе", getForecastInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid", getForecastInfo.getPhrases()[0].getAuctionBids(), notNullValue());
        forecastAuctionBidses = getForecastInfo.getPhrases()[0].getAuctionBids();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7258")
    public void checkSortForFieldBid() {
        //DIRECT-45726
        List<Float> bids = Stream.of(forecastAuctionBidses)
                .map(phraseActionBid -> phraseActionBid.getBid())
                .collect(Collectors.toList());
        assertThat("значения Bid убывают", Ordering.from(reverseOrder()).isStrictlyOrdered(bids), equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7259")
    public void checkSortForFieldPrice() {
        //DIRECT-45726
        List<Float> prices = Stream.of(forecastAuctionBidses)
                .map(phraseActionBid -> phraseActionBid.getPrice())
                .collect(Collectors.toList());
        assertThat("значения Bid убывают", Ordering.from(reverseOrder()).isStrictlyOrdered(prices), equalTo(true));
    }
}
