package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.common.api45mng.PhraseAuctionBids;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPosition;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.lessThan;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 13.08.15.
 * https://st.yandex-team.ru/TESTIRT-6714
 */
@Aqua.Test
@Features(StatFeatures.BUG)
@Stories(ApiStories.VCG)
@Issue("https://st.yandex-team.ru/DIRECT-44294")
@Description("Проверка правильного соотношения Price и Bid в AuctionBids")
@RunWith(Parameterized.class)
public class AuctionBidsValuesTest {
    private static PhraseAuctionBids[] forecastAuctionBidses;
    public static String forecastPhrase = "лето";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public AuctionBidsPosition position;

    @Parameterized.Parameters(name = "Position = {0}")
    public static Collection positions() {
        List<Object[]> data = new ArrayList<Object[]>();
        for (AuctionBidsPosition auctionBidsPosition : AuctionBidsPosition.values()) {
            data.add(new Object[]{auctionBidsPosition});
        }
        return data;
    }

    @BeforeClass
    public static void getForecastReports() {
        NewForecastInfoExtendedMap newForecastInfoExtendedMap = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.toString())
                .withAuctionBids(Value.YES);
        GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfoExtendedMap);
        assumeThat("вернуля прогноз по 1 фразе", getForecastInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid", getForecastInfo.getPhrases()[0].getAuctionBids(), notNullValue());
        forecastAuctionBidses = getForecastInfo.getPhrases()[0].getAuctionBids();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7260")
    public void checkValues() {
        //DIRECT-45726
        PhraseAuctionBids phraseAuctionBids = Stream.of(forecastAuctionBidses)
                .filter(phraseActionBid -> phraseActionBid.getPosition().equals(position.toString()))
                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
        if (position.equals(AuctionBidsPosition.P13) || position.equals(AuctionBidsPosition.P24)) {
            assertThat("значение Bid равно значению Price",
                    phraseAuctionBids.getPrice(), equalTo(phraseAuctionBids.getBid()));
        } else {
            assertThat("значение Bid больше значения Price",
                    phraseAuctionBids.getPrice(), lessThan(phraseAuctionBids.getBid()));
        }
    }
}
