package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 15.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Проверка зависимости поля AuctionBids от входного параметра.")
public class ForecastSyncAuctionBidsFieldTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String auctionBidValue;

    @Parameterized.Parameter(value = 1)
    public boolean isContained;
    private int forecastID;
    public static String forecastPhrase = "лето";

    @Parameterized.Parameters(name = "version = {0}, auctionBids = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Value.YES, true},
                {Value.NO, false},
                {null, false}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7263")
    public void checkFieldInResponse(){
        String getForecastSyncInfo = api.userSteps.jsonClient().sendRequest(
                Method.GET_FORECAST_SYNC,
                new NewForecastInfoExtendedMap(api.wsdl(APIPort_PortType.class).type())
                    .withPhrases(forecastPhrase)
                    .withCurrency(Currency.RUB.value())
                    .withAuctionBids(auctionBidValue).getBean()
        );
        assertThat("AuctionBids возвращается в зависимости от значения входного параметра",
                getForecastSyncInfo.contains(capitalize(NewForecastInfoMap.AUCTION_BIDS)),
                equalTo(isContained));
    }
}
