package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.common.api45mng.PhraseAuctionBids;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.phrases.PhraseAuctionBidMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 20.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Проверка проверка корректности возвращаемой структуры AuctionBids.")
public class ForecastSyncAuctionBidsStructureTest {
    public static String forecastPhrase = "лето";
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static GetForecastInfo forecastSyncInfo;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "Protocol = {0}")
    public static Collection protocol() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }

    @Before
    public void createForecastReport(){
        NewForecastInfoExtendedMap newForecastInfoExtendedMap = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.value())
                .withAuctionBids(Value.YES);
        forecastSyncInfo = api.protocol(protocol).userSteps.forecastSteps().getForecastSync(newForecastInfoExtendedMap);
        assumeThat("вернулся прогноз по 1 фразе", forecastSyncInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid",forecastSyncInfo.getPhrases()[0].getAuctionBids(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7264")
    public void checkAuctionBidsStructureInResponse(){
        PhraseAuctionBids[] gotAuctionBids = forecastSyncInfo.getPhrases()[0].getAuctionBids();
        AuctionBidsPositionForBids[] positions = AuctionBidsPositionForBids.values();
        List<PhraseAuctionBids> expectedAuctionBids =  Stream.of(positions)
                        .map(position ->
                                (PhraseAuctionBids)
                                new PhraseAuctionBidMap(api.type())
                                        .withPosition(position.toString())
                                        .withBid(0f)
                                        .withPrice(0f).getBean()

                        )
                        .collect(Collectors.toList());
        MatchVariation variation = new DefaultMatchVariation().forClasses(Float.class).useMatcher(greaterThan(0f));
        assertThat("AuctionBids возвращается корректной стрыктуры", Arrays.asList(gotAuctionBids),
                beanDiffer(expectedAuctionBids).withVariation(variation));

    }

}
