package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.steps.forecast.ApproximateNumbersMatchVariation;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;
import static ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints.ignore;

/**
 * Created by ginger on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Сравнение ответа метода с и без AuctionBids.")
public class ForecastSyncCompareWithAndWithoutAuctionBidsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static GetForecastInfo forecastSyncInfo;
    public static String forecastPhrase = "лето";
    private GetForecastInfo forecastSyncInfoWithoutBids;


    @BeforeClass
    public static void createForecastReport(){
        NewForecastInfoExtendedMap newForecastInfoExtendedMap = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.value())
                .withAuctionBids(Value.YES);
        forecastSyncInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfoExtendedMap);
        assumeThat("вернуля прогноз по 1 фразе", forecastSyncInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid",forecastSyncInfo.getPhrases()[0].getAuctionBids(), notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7265")
    public void compareWithDiffValueOfAuctionBid(){
        NewForecastInfoExtendedMap forecastExtendedMapWithoutAuctionBids = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.value())
                .withAuctionBids(Value.NO);
        forecastSyncInfoWithoutBids = api.userSteps.forecastSteps().getForecastSync(forecastExtendedMapWithoutAuctionBids);
        assertThat("прогнозы совпадают",
                forecastSyncInfo,
                beanEquivalent(forecastSyncInfoWithoutBids)
                        .withVariation(new ApproximateNumbersMatchVariation(5, 0, true))
                        .fields(ignore(NewForecastInfoMap.AUCTION_BIDS)));
    }
}
