package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.common.AuctionBidsPositionForBids;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 15.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Проверка маппинга полей Min, Max, PremiumMin, PremiumMax.")
@RunWith(Parameterized.class)
public class ForecastSyncMinMaxWithAuctionBidsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static GetForecastInfo forecastSyncInfo;
    public static String forecastPhrase = "лето";

    @Parameterized.Parameter(0)
    public String field;

    @Parameterized.Parameter(1)
    public AuctionBidsPositionForBids position;

    @Parameterized.Parameters(name = "Field = {0}, Position = {1}")
    public static Collection protocol() {
        Object[][] data = new Object[][]{
                {BannerPhraseInfoMap.MAX,AuctionBidsPositionForBids.P21},
                {BannerPhraseInfoMap.MIN,AuctionBidsPositionForBids.P24},
                {BannerPhraseInfoMap.PREMIUM_MAX,AuctionBidsPositionForBids.P11},
                {BannerPhraseInfoMap.PREMIUM_MIN,AuctionBidsPositionForBids.P14}
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void createForecastReport(){
        NewForecastInfoExtendedMap newForecastInfoExtendedMap = new NewForecastInfoExtendedMap(api.type())
                .withPhrases(forecastPhrase)
                .withCurrency(Currency.RUB.value())
                .withAuctionBids(Value.YES);
        forecastSyncInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfoExtendedMap);
        assumeThat("вернуля прогноз по 1 фразе", forecastSyncInfo.getPhrases().length, equalTo(1));
        assumeThat("вернулась структура AuctionBid",forecastSyncInfo.getPhrases()[0].getAuctionBids(), notNullValue());
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7266")
    public void checkFieldValue(){
        Float auctionFieldBid =
                Stream.of(forecastSyncInfo.getPhrases()[0].getAuctionBids())
                        .filter(auctionBid -> auctionBid.getPosition().equals(position.toString()))
                        .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой ставки")).getBid();
        Float phraseField = (Float) ( new BannerPhraseInfoMap(forecastSyncInfo.getPhrases()[0])).get(field);
        assertThat("верный маппинг для " + capitalize(field), phraseField, equalTo(auctionFieldBid));
    }

}
