package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.model.statistics.PeriodType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.List;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasItem;

/**
 * User: ginger
 * Date: 12.04.13
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
public class GetForecastSyncPeriodTypeAndPeriodValueFieldsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class)
            .as(Logins.SUPER_LOGIN,Logins.SUPER_READER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7274")
    public void getForecastSyncWithValidPeriodValueTypeMonthTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.MONTH)
                .withPeriodValue(8);

        List<String> phrases = api.userSteps.forecastSteps().getForecastReportPhrases(newForecastInfo);

        Assert.assertThat("Неверный отчет", phrases, hasItem("президент"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7275")
    public void getForecastSyncWithValidPeriodValueTypeQuarterTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.QUARTER)
                .withPeriodValue(3);

        List<String> phrases = api.userSteps.forecastSteps().getForecastReportPhrases(newForecastInfo);

        Assert.assertThat("Неверный отчет", phrases, hasItem("президент"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7276")
    public void getForecastSyncWithValidPeriodValueTypeYearTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.YEAR)
                .withPeriodValue(3);

        List<String> phrases = api.userSteps.forecastSteps().getForecastReportPhrases(newForecastInfo);

        Assert.assertThat("Неверный отчет", phrases, hasItem("президент"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7277")
    public void getForecastSyncWithInvalidValuePeriodTypeMonthTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.MONTH)
                .withPeriodValue(16);

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71, AxisErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_GREATER_THAN,
                        capitalize(NewForecastInfoExtendedMap.PERIOD_VALUE), 12));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7278")
    public void getForecastSyncWithInvalidValuePeriodTypeQuarterTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.QUARTER)
                .withPeriodValue(5);

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71, AxisErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_GREATER_THAN,
                        capitalize(NewForecastInfoExtendedMap.PERIOD_VALUE), 4));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7279")
    public void getForecastSyncWithInvalidNullValueNotNullTypeTest() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("президент")
                .withCurrency(Currency.RUB.value())
                .withPeriodType(PeriodType.MONTH);

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(NewForecastInfoExtendedMap.PERIOD_VALUE)));
    }

}
