package ru.yandex.autotests.directapi.stat.getforecastsync;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * User: voronov
 * Date: 30.06.17
 */

@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@ParametersAreNonnullByDefault
public class GetForecastSyncPhraseValidationTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String login = StatLogins.MANAGER_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void enableAPI() {
        api.userSteps.clientFakeSteps().enableAPI(login);
    }

    // подсмотрел тут https://st.yandex-team.ru/DIRECT-65248#1498140987000

    @Test
    public void normalizedFormOfMinusWordMathesWithFormOfKeyword() {
        // Нормализованная форма минус-слова совпадает с нормализованной формой одного из ключевых слов

        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("деревянный дом -деревянное");

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71,
                        AxisErrorDetails.YOU_CANNOT_USE_WORDS_OF_SOURCE_KEYWORD_PHRASE_AS_NEGATIVE_KEYWORDS,
                        "деревянное", "деревянный дом -деревянное"));
    }

    @Test
    public void formOfMinusWordLocked() {
        // Форма минус-слова зафиксирована
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withPhrases("деревянный дом -!деревянное -!деревянный");

        GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfo);
        assumeThat("нет ошибок вадиации", getForecastInfo.getPhrases().length, not(0));
    }

    @Test
    public void lockedFormOfMinusWordMathesWithLockedFormOfPhrase() {
        // Зафиксированная форма минус-слова совпадает с зафиксированной формой слова в ключевой фразе
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("!деревянный дом -!деревянный");

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71,
                        AxisErrorDetails.YOU_CANNOT_USE_WORDS_OF_SOURCE_KEYWORD_PHRASE_AS_NEGATIVE_KEYWORDS,
                        "!деревянный", "!деревянный дом -!деревянный"));
    }

    @Test
    public void lockedFormOfMinusWordNotMathesWithLockedFormOfPhrase() {
        // Зафиксированные формы ключевого и минус-слова не совпадают
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withPhrases("!деревянный дом -!деревянное");

        GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfo);
        assumeThat("нет ошибок вадиации", getForecastInfo.getPhrases().length, not(0));
    }

    @Test
    public void formOfMinusWordIsLockedFormOfPhraseIsNot() {
        // Форма ключевого слова зафиксирована, минус-слова - нет
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withPhrases("!деревянный дом -деревянные");

        api.userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(71,
                        AxisErrorDetails.YOU_CANNOT_USE_WORDS_OF_SOURCE_KEYWORD_PHRASE_AS_NEGATIVE_KEYWORDS,
                        "деревянные", "!деревянный дом -деревянные"));
    }
}
