package ru.yandex.autotests.directapi.stat.getforecastsync;

import ch.lambdaj.function.convert.PropertyExtractor;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ForecastCalculator;
import ru.yandex.autotests.direct.utils.converter.BannerPhraseInfoConverter;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.BannerPhraseInfo;
import ru.yandex.autotests.directapi.common.api45mng.ForecastCommonInfo;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.autotests.irt.testutils.matchers.IsCloseTo;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static ch.lambdaj.Lambda.convert;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * User: pavryabov
 * Date: 30.12.13
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@RunWith(Parameterized.class)
public class GetForecastSyncWithCurrencyTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void enableAPI() {
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.MANAGER_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.SUPPORT);
    }

    @Parameterized.Parameter(value = 0)
    public String login;

    @Parameterized.Parameter(value = 1)
    public Currency currency;

    @Parameterized.Parameters(name = "Login = {0}, Currency = {1}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {Logins.SUPER_LOGIN, Currency.RUB},
                {Logins.SUPER_LOGIN, Currency.USD},
                {Logins.SUPER_LOGIN, Currency.UAH},
                {Logins.SUPER_LOGIN, Currency.EUR},
                {Logins.SUPER_LOGIN, Currency.CHF},
                {Logins.SUPER_LOGIN, Currency.TRY},
                {Logins.SUPER_LOGIN, Currency.KZT},
                {Logins.SUPER_LOGIN, Currency.BYN},
                {Logins.SUPER_READER, Currency.RUB},
                {Logins.SUPER_READER, Currency.USD},
                {Logins.SUPER_READER, Currency.UAH},
                {Logins.SUPER_READER, Currency.EUR},
                {Logins.SUPER_READER, Currency.CHF},
                {Logins.SUPER_READER, Currency.TRY},
                {Logins.SUPER_READER, Currency.KZT},
                {Logins.SUPER_READER, Currency.BYN},
                {Logins.PLACER, Currency.RUB},
                {Logins.PLACER, Currency.USD},
                {Logins.PLACER, Currency.UAH},
                {Logins.PLACER, Currency.EUR},
                {Logins.PLACER, Currency.CHF},
                {Logins.PLACER, Currency.TRY},
                {Logins.PLACER, Currency.KZT},
                {Logins.PLACER, Currency.BYN},
                {Logins.SUPPORT, Currency.RUB},
                {Logins.SUPPORT, Currency.USD},
                {Logins.SUPPORT, Currency.UAH},
                {Logins.SUPPORT, Currency.EUR},
                {Logins.SUPPORT, Currency.CHF},
                {Logins.SUPPORT, Currency.TRY},
                {Logins.SUPPORT, Currency.KZT},
                {Logins.SUPPORT, Currency.BYN},
                {Logins.MEDIA, Currency.RUB},
                {Logins.MEDIA, Currency.USD},
                {Logins.MEDIA, Currency.UAH},
                {Logins.MEDIA, Currency.EUR},
                {Logins.MEDIA, Currency.CHF},
                {Logins.MEDIA, Currency.TRY},
                {Logins.MEDIA, Currency.KZT},
                {Logins.MEDIA, Currency.BYN},
                {Logins.MANAGER_DEFAULT, Currency.RUB},
                {Logins.MANAGER_DEFAULT, Currency.USD},
                {Logins.MANAGER_DEFAULT, Currency.UAH},
                {Logins.MANAGER_DEFAULT, Currency.EUR},
                {Logins.MANAGER_DEFAULT, Currency.CHF},
                {Logins.MANAGER_DEFAULT, Currency.TRY},
                {Logins.MANAGER_DEFAULT, Currency.KZT},
                {Logins.MANAGER_DEFAULT, Currency.BYN}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7281")
    public void getReportWithCurrencyTest() {
        NewForecastInfoExtendedMap newForecastInfoMap = new NewForecastInfoExtendedMap(api.type());
        newForecastInfoMap.withPhrases("вода");
        newForecastInfoMap.withCategories(new int[0]);
        newForecastInfoMap.withCurrency(currency.toString());
        GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecastSync(newForecastInfoMap);
        log.info("Получили идентификатор отчета. Проверяем правильность валюты в отчете");
        List<String> currencies = convert(getForecastInfo.getPhrases(),
                new PropertyExtractor<Object, String>("currency"));

        assertThat("корретный отчет forecast",
                currencies, everyItem(equalTo(currency.toString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7282")
    public void checkForecastCommonTest() {
        NewForecastInfoExtendedMap newForecastInfoMap = new NewForecastInfoExtendedMap(api.type());
        newForecastInfoMap.withPhrases("вода");
        newForecastInfoMap.withCategories(new int[0]);
        newForecastInfoMap.withCurrency(currency.toString());
        GetForecastInfo getForecastInfoCurrency = api.userSteps.forecastSteps().getForecastSync(newForecastInfoMap);

        ForecastCommonInfo expectedCommon = ForecastCalculator.calculate(getForecastInfoCurrency);
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(BannerPhraseInfoMap.PREMIUM_MIN)
                .useMatcher(IsCloseTo.closeTo(expectedCommon.getPremiumMin(), 0.011f))
                .forFields(BannerPhraseInfoMap.MIN)
                .useMatcher(IsCloseTo.closeTo(expectedCommon.getMin(), 0.011f))
                .forFields(BannerPhraseInfoMap.MAX)
                .useMatcher(IsCloseTo.closeTo(expectedCommon.getMax(), 0.011f));

        assertThat("корректные значения итоговых данных отчета",
                getForecastInfoCurrency.getCommon(), beanDiffer(expectedCommon).withVariation(variation));
    }
}
