package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.common.api45mng.BannerPhraseInfo;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.phrases.Categories;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.forecast.ForecastSteps;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.Arrays;
import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.*;

/**
 * User: ginger
 * Date: 09.04.13
 *
 * тесты на логику аналогично CreateNewForecast (не указан PeriodType)
 * https://jira.yandex-team.ru/browse/DIRECT-20989
 */

@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
public class GetForecastSyncWithoutNewFieldsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(Logins.MANAGER_GEO);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7285")
    public void ignoreIncorrectNumberOfCategories() {
        int[] categories = new int[ForecastSteps.NEW_FORECAST_SYNC_REPORT_PHRASES_LIMIT + 1];
        Arrays.fill(categories, Categories.OKNA);
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withCategories(categories)
                .withPhrases("отдых в Италии");
        List<String> phrases = api.userSteps.forecastSteps().getForecastReportPhrases(newForecastInfo);

        assertThat("отчет корректнен", phrases, hasItem("отдых в Италии"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7286")
    public void compareCreateNewForecastAndGetForecastSync() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withCategories(Categories.OKNA)
                .withPhrases("президент");

        api.userSteps.forecastSteps().compareForecastToSyncReport(newForecastInfo, 10);
     }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7284")
    public void couldGetForecastSyncWithOnePhrase() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withPhrases("президент");
        api.userSteps.forecastSteps().compareForecastToSyncReport(newForecastInfo, 10);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7287")
    public void forecastSyncMatchesAsyncHyphenPhraseTest() {
        String hyphenPhrase = "юго-запад";
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withPhrases(hyphenPhrase);
        api.userSteps.forecastSteps().compareForecastToSyncReport(newForecastInfo, 10);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7288")
    public void forecastSyncHyphenPhraseTest() {
        //https://st.yandex-team.ru/DIRECT-35408
        String hyphenPhrase = "Нью-Йорк";
        GetForecastInfo report = api.userSteps.forecastSteps().getForecastSync(
                new NewForecastInfoExtendedMap(api.type())
                        .withPhrases(hyphenPhrase)
                        .withCurrency(Currency.RUB.value())
        );
        List<String> phrasesReturned = extract(report.getPhrases(), on(BannerPhraseInfo.class).getPhrase());
        assertThat("фраза корректна", phrasesReturned, contains(hyphenPhrase));
    }
}
