package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.hasItem;
import static org.junit.Assert.assertThat;

/**
 * User: ginger
 * Date: 09.04.13
 *
 * тесты на логику аналогично CreateNewForecast (не указан PeriodType)
 * https://jira.yandex-team.ru/browse/DIRECT-20989
 */

@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@RunWith(Parameterized.class)
public class InternalRoleAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameters
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPER_READER},
                {Logins.SUPPORT},
                {Logins.PLACER},
                {Logins.MEDIA}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7289")
    public void couldGetForecastSync() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCurrency(Currency.RUB.value())
                .withCategories(new int[0])
                .withPhrases("президент");

        List<String> phrases = api.as(Logins.SUPER_LOGIN,login)
                .userSteps.forecastSteps().getForecastReportPhrases(newForecastInfo);

        assertThat("Неверный отчет", phrases, hasItem("президент"));
    }
}
