package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

import static org.apache.commons.lang.StringUtils.capitalize;


/**
 * Created by ginger on 16.07.15.
 * https://st.yandex-team.ru/TESTIRT-6262
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@Issue("https://st.yandex-team.ru/DIRECT-42742")
@Description("Валидация полей.")
@RunWith(Parameterized.class)
public class InvalidJsonForecastSyncStructureTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_READER).version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object invalidAuctionBid;

    public static String phraseForReport = "лето";
    public static String invalidStringAuctionBid = "yes";
    public static Integer invalidIntegerAuctionBid = 1331;
    public static String[] invalidStructureAuctionBid = new String[]{Value.YES};

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection auctionBid() {
        Object[][] data = new Object[][]{
                {"Значение строки с маленькой буквы", invalidStringAuctionBid},
                {"Целое число вместо строки", invalidIntegerAuctionBid},
                {"Массив вместо строки", invalidStructureAuctionBid}
        };
        return Arrays.asList(data);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7290")
    public void trySetInvalidAuctionBid(){
        HashMap newForecastExtendedInfoMap = new HashMap();
        newForecastExtendedInfoMap.put(capitalize(NewForecastInfoMap.PHRASES), new String[]{phraseForReport});
        newForecastExtendedInfoMap.put(capitalize(NewForecastInfoMap.AUCTION_BIDS), invalidAuctionBid);
        newForecastExtendedInfoMap.put(capitalize(NewForecastInfoMap.CURRENCY), Currency.RUB.value());
        api.userSteps.shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastExtendedInfoMap,
                new AxisError(25, AxisErrorDetails.FIELD,capitalize(NewForecastInfoMap.AUCTION_BIDS)));
    }
}
