package ru.yandex.autotests.directapi.stat.getforecastsync;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoExtendedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.Arrays;
import java.util.Collection;

/**
 * User: ginger
 * Date: 10.04.13
 */
@Aqua.Test
@Features(StatFeatures.GET_FORECAST_SYNC)
@RunWith(Parameterized.class)
public class NoRightGetForecastSyncTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameters
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.AGENCY_YE_DEFAULT},
                {Logins.CLIENT_FREE_YE_DEFAULT}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7291")
    public void couldGetForecastSync() {
        NewForecastInfoExtendedMap newForecastInfo = new NewForecastInfoExtendedMap(api.type())
                .withGeoID(1)
                .withCategories(new int[0])
                .withPhrases("президент");

        api.as(login).userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_FORECAST_SYNC,
                newForecastInfo,
                new AxisError(54)
        );
    }
}
