package ru.yandex.autotests.directapi.stat.getkeywordintersection;


import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordIntersectionRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.greaterThan;

/**
 * User: pavryabov
 * Date: 19.02.14
 *
 * https://jira.yandex-team.ru/browse/DIRECT-28424
 */
@Aqua.Test
@Features(StatFeatures.NOT_REGRESSION_YET)
@Stories(ApiStories.AVAILABLE_INT)
public class GetKeywordsIntersectionAvailableIntTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String CLIENT = Logins.CLIENT_FREE_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.AGENCY_YE_DEFAULT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignID;
    private Long campaignIDElse;

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CLIENT_FREE_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.AGENCY_YE_DEFAULT);
    }

    @Before
    public void initTest() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(Logins.CLIENT_FREE_YE_DEFAULT);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, CLIENT);
        api.userSteps.keywordsSteps().addKeyword(CLIENT, adGroupId1, "белый");
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId1, CLIENT);
        campaignIDElse = api.userSteps.campaignSteps().addDefaultTextCampaign(Logins.CLIENT_FREE_YE_DEFAULT);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignIDElse, CLIENT);
        api.userSteps.keywordsSteps().addKeyword(CLIENT, adGroupId2, "белого");
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId2, CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7292")
    public void availableLongIn2VersionTest() {
        api.version(2).wsdl(ru.yandex.autotests.directapi.common.api45mngf.APIPort_PortType.class);
        ru.yandex.autotests.directapi.common.api45mngf.KeywordIntersectionResponse keywordsResponse =
                api.userSteps.soapClient().invokeMethod(Method.GET_KEYWORDS_INTERSECTION,
                        new KeywordIntersectionRequestMap(api.type())
                                .withCampaignIDS(campaignID.intValue(), campaignIDElse.intValue()).getBean()
                );
        assertThat(
                extract(keywordsResponse.getIntersectingKeywords()[0],
                        on(ru.yandex.autotests.directapi.common.api45mngf.KeywordItem.class).getKeywordID()),
                everyItem(greaterThan(0l))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7293")
    public void availableLongIn104VersionTest() {
        api.version(104).wsdl(ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType.class);
        ru.yandex.autotests.directapi.common.api45mng.KeywordIntersectionResponse keywordsResponse =
                api.userSteps.soapClient().invokeMethod(Method.GET_KEYWORDS_INTERSECTION,
                        new KeywordIntersectionRequestMap(api.type())
                                .withCampaignIDS(campaignID.intValue(), campaignIDElse.intValue()).getBean()
                );
        assertThat(
                extract(keywordsResponse.getIntersectingKeywords()[0],
                        on(ru.yandex.autotests.directapi.common.api45mng.KeywordItem.class).getKeywordID()),
                everyItem(greaterThan(0l))
        );
    }

}
