package ru.yandex.autotests.directapi.stat.getkeywordintersection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordIntersectionRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: ginger
 * Date: 15.04.13
 *
 * https://jira.yandex-team.ru/browse/DIRECT-20605
 */
@Aqua.Test
@Features(StatFeatures.GET_KEYWORDS_INTERSECTION)
public class GetKeywordsIntersectionRequestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(Logins.AGENCY_YE_DEFAULT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(Logins.CLIENT_FREE_YE_DEFAULT);

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CLIENT_FREE_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.AGENCY_YE_DEFAULT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7295")
    public void callGetKeywordsIntersectionWithEmptyArrayExpectedError() {
        KeywordIntersectionRequestMap keywordsIntersection = new KeywordIntersectionRequestMap(api.type());
        api.userSteps.statisticsSteps().shouldGetErrorOn(
                Method.GET_KEYWORDS_INTERSECTION,
                keywordsIntersection,
                new AxisError(71, AxisErrorDetails.ON_OF_THE_FIELDS_KEYWORDS_CAMPAIGNIDS_MUST_BE_COMPLETED)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7296")
    public void callGetKeywordsIntersectionWithNoRightsCampaignExpectedError() {
        KeywordIntersectionRequestMap keywordsIntersection = new KeywordIntersectionRequestMap(api.type())
                .withCampaignIDS(campaignId.intValue(), 263);
        api.userSteps.statisticsSteps().shouldGetErrorOn(
                Method.GET_KEYWORDS_INTERSECTION,
                keywordsIntersection,
                new AxisError(54)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7297")
    public void callGetKeywordsIntersectionWithoutRequiredFieldsExpectedError() {
        KeywordIntersectionRequestMap keywordsIntersection = new KeywordIntersectionRequestMap(api.type())
                .withWithKeywords("чёрный", "чёрное", "белое");
        api.userSteps.statisticsSteps().shouldGetErrorOn(
                Method.GET_KEYWORDS_INTERSECTION,
                keywordsIntersection,
                new AxisError(71, AxisErrorDetails.ON_OF_THE_FIELDS_KEYWORDS_CAMPAIGNIDS_MUST_BE_COMPLETED)
        );
    }
}
